/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.salju.kobolds.init.KoboldsBanners;
import net.salju.kobolds.init.KoboldsBlocks;
import net.salju.kobolds.init.KoboldsEnchantments;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsModEntities;
import net.salju.kobolds.init.KoboldsModSounds;
import net.salju.kobolds.init.KoboldsStructures;
import net.salju.kobolds.init.KoboldsTabs;

@Mod(value="kobolds")
public class KoboldsMod {
    public static final String MODID = "kobolds";
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public KoboldsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        KoboldsTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        KoboldsModSounds.REGISTRY.register(bus);
        KoboldsBlocks.REGISTRY.register(bus);
        KoboldsItems.REGISTRY.register(bus);
        KoboldsBanners.REGISTRY.register(bus);
        KoboldsModEntities.REGISTRY.register(bus);
        KoboldsEnchantments.REGISTRY.register(bus);
        KoboldsStructures.REGISTRY.register(bus);
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

